/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.output;

import com.badlogic.gdx.math.GridPoint2;
import technology.rocketjump.undermount.mapgen.model.output.CompassDirection;

public class MapEdgeSection {
    public final CompassDirection direction;
    public final GridPoint2 minimum;
    public final GridPoint2 maximum;

    public MapEdgeSection(CompassDirection direction, GridPoint2 initialPoint) {
        this.direction = direction;
        this.minimum = initialPoint.cpy();
        this.maximum = initialPoint.cpy();
    }

    public MapEdgeSection(MapEdgeSection other) {
        this.direction = other.direction;
        this.minimum = other.minimum.cpy();
        this.maximum = other.maximum.cpy();
    }

    public void addAdjacentPoint(GridPoint2 adjacentPoint) {
        this.minimum.x = Math.min(this.minimum.x, adjacentPoint.x);
        this.minimum.y = Math.min(this.minimum.y, adjacentPoint.y);
        this.maximum.x = Math.max(this.maximum.x, adjacentPoint.x);
        this.maximum.y = Math.max(this.maximum.y, adjacentPoint.y);
    }

    public boolean isAdjacent(GridPoint2 adjacentPoint) {
        if (Math.abs(adjacentPoint.x - this.minimum.x) <= 1 && Math.abs(adjacentPoint.y - this.minimum.y) <= 1) {
            return true;
        }
        return Math.abs(adjacentPoint.x - this.maximum.x) <= 1 && Math.abs(adjacentPoint.y - this.maximum.y) <= 1;
    }
}

